//
//  MCDateRange.h
//  MCFoundation
//
//  Created by Ali Lalani on 2/9/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCDateRangeEnumerator.h"


@class BDQualifier;
@interface MCDateRange : NSObject {
	NSString *offset;
	NSString *skipDays;
	NSCalendarDate *startDate;
	NSCalendarDate *endDate;

	BOOL negativeOffset;

	BOOL isPastRange;
	BOOL isFutureRange;
	BOOL isTodayRange;
}
+ (MCDateRange *)rangeWithStartDate:(NSCalendarDate *)start endDate:(NSCalendarDate *)end;
+ (MCDateRange *)rangeWithOffset:(NSString *)offsetString;
+ (MCDateRange *)pastRange;
+ (MCDateRange *)futureRange;
+ (MCDateRange *)todayRange;

- (BDQualifier *)qualifierForKeyPath:(NSString *)keyPath useCompleteDays: (BOOL)flag;
- (BDQualifier *)qualifierForKeyPath:(NSString *)keyPath;
- (BDQualifier*)qualifierForStartKeyPath:(NSString*)startKeyPath 
                              endKeyPath:(NSString*)endKeyPath
                         useCompleteDays:(BOOL)flag;


// Only works with ranges created with start and end dates
- (BOOL)containsDate: (NSCalendarDate*)aDate;
- (int)count;
- (NSCalendarDate*)dateAtIndex: (int)index;
- (int)indexOfDate: (NSCalendarDate*)date;
- (NSArray*)dates;
- (NSCalendarDate*)midCalendarDate;
- (void)translateDateRangeByDays: (int)days;
- (NSArray*)dateRangesForEnumerationMode: (MCDateRangeEnumerationMode)mode weekStartDay:(MCNSDayOfWeek)weekStart;
// This method allows you to specify whether you want the comparison to be for the day or normal date comparison
//  i.e. if you pass in YES then isSameCalendarDate: is used to do comparisons, otherwise isEqualToDate: is used
- (BOOL)isEqualToDateRange: (MCDateRange*)range useDayPrecision: (BOOL)useDayPrecision;

- (BOOL)negativeOffset;
- (void)setNegativeOffset:(BOOL)flag;

- (NSString *)offset;
- (void)setOffset:(NSString *)anOffset;

- (NSString *)skipDays;
- (void)setSkipDays:(NSString *)aSkipDays;

- (NSCalendarDate *)startDate;
- (void)setStartDate:(NSCalendarDate *)aStartDate;

- (NSCalendarDate *)endDate;
- (void)setEndDate:(NSCalendarDate *)anEndDate;

- (BOOL)isPastRange;
- (BOOL)isFutureRange;
- (BOOL)isTodayRange;
- (void)setPastRange:(BOOL)flag;
- (void)setFutureRange:(BOOL)flag;
- (void)setTodayRange:(BOOL)flag;
@end
